\
// ---------------------------------------------------------
// Nano Ardule - Step 03: MIDI TX Smoke Test
// 목적: Arduino Nano TX(D1)를 통해 MIDI 메시지를 전송하는 기본 테스트
// 작성일: 2025-08-25
// ---------------------------------------------------------

#define MIDI_BAUD 31250
#define ACT_LED 9

// 테스트 채널 (1 = CH1)
#define CH_A 1

void sendByte(uint8_t b) {
  Serial.write(b);
}

void sendProgramChange(uint8_t channel, uint8_t program) {
  sendByte(0xC0 | ((channel-1) & 0x0F));
  sendByte(program & 0x7F);
}

void sendControlChange(uint8_t channel, uint8_t cc, uint8_t val) {
  sendByte(0xB0 | ((channel-1) & 0x0F));
  sendByte(cc & 0x7F);
  sendByte(val & 0x7F);
}

void sendNoteOn(uint8_t channel, uint8_t note, uint8_t vel) {
  sendByte(0x90 | ((channel-1) & 0x0F));
  sendByte(note & 0x7F);
  sendByte(vel & 0x7F);
}

void sendNoteOff(uint8_t channel, uint8_t note, uint8_t vel) {
  sendByte(0x80 | ((channel-1) & 0x0F));
  sendByte(note & 0x7F);
  sendByte(vel & 0x7F);
}

void activity() {
  digitalWrite(ACT_LED, HIGH);
  delay(10);
  digitalWrite(ACT_LED, LOW);
}

void setup() {
  pinMode(ACT_LED, OUTPUT);
  digitalWrite(ACT_LED, LOW);

  // MIDI baud rate
  Serial.begin(MIDI_BAUD);

  delay(500); // 안정 대기

  // 초기 메시지: Program Change, Volume, Pan
  sendProgramChange(CH_A, 0); // Acoustic Grand Piano
  sendControlChange(CH_A, 7, 100); // Volume
  sendControlChange(CH_A, 10, 64); // Pan
  activity();
}

void loop() {
  static const uint8_t notes[] = {60, 64, 67}; // C, E, G
  static uint8_t idx = 0;

  uint8_t note = notes[idx];
  idx = (idx + 1) % 3;

  sendNoteOn(CH_A, note, 100);
  activity();
  delay(400);
  sendNoteOff(CH_A, note, 64);
  delay(300);
}
