// ---------------------------------------------------------
// Nano Ardule MIDI Controller
// Step 01: Power, LCD, LED Smoke Test
// 작성일: 2025-08-21
// ---------------------------------------------------------

#include <Wire.h>
#include <LiquidCrystal_I2C.h>

// ===== 사용자 환경에 맞게 조정할 항목 =====
#define LCD_ADDR 0x27      // 대부분 0x27 또는 0x3F
#define LCD_COLS 16
#define LCD_ROWS 2
//#define USE_SERIAL_LOG    // 시리얼 로그 사용 시 주석 해제

// ===== 핀 매핑 (설계 요약 문서 기준) =====
const int LED_ACTIVITY = 9;   // D9: MIDI Activity LED
const int LED_PART_A   = A0;  // A0: Part A LED
const int LED_PART_B   = A1;  // A1: Part B LED
const int LED_DRUMS    = A2;  // A2: Drums LED

LiquidCrystal_I2C lcd(LCD_ADDR, LCD_COLS, LCD_ROWS);

// LED 한 번씩 점등 (과다전류/발열 체크)
void ledSequenceOnce(uint16_t on_ms = 200, uint16_t gap_ms = 120) {
  const int leds[] = { LED_ACTIVITY, LED_PART_A, LED_PART_B, LED_DRUMS };
  for (int i = 0; i < 4; i++) {
    digitalWrite(leds[i], HIGH);
    delay(on_ms);
    digitalWrite(leds[i], LOW);
    delay(gap_ms);
  }
}

void setup() {
#ifdef USE_SERIAL_LOG
  Serial.begin(115200);
  delay(50);
  Serial.println(F("[Step01] Booting..."));
#endif

  // LED 핀 준비 (기본 LOW)
  pinMode(LED_ACTIVITY, OUTPUT);
  pinMode(LED_PART_A,   OUTPUT);
  pinMode(LED_PART_B,   OUTPUT);
  pinMode(LED_DRUMS,    OUTPUT);
  digitalWrite(LED_ACTIVITY, LOW);
  digitalWrite(LED_PART_A,   LOW);
  digitalWrite(LED_PART_B,   LOW);
  digitalWrite(LED_DRUMS,    LOW);

  // LCD 초기화
  lcd.init();
  lcd.backlight();
  lcd.clear();
  lcd.setCursor(0, 0);
  lcd.print("Hello, Ardule");
  lcd.setCursor(0, 1);
  lcd.print("Power/LCD/LED");
#ifdef USE_SERIAL_LOG
  Serial.println(F("[Step01] LCD hello shown"));
#endif
  delay(1500);

  // READY 화면
  lcd.clear();
  lcd.setCursor(5, 0);   // 가운데쯤
  lcd.print("READY");
  lcd.setCursor(0, 1);
  lcd.print("Smoke Test OK?");
#ifdef USE_SERIAL_LOG
  Serial.println(F("[Step01] READY"));
#endif

  // LED 시퀀스(각 LED 한 번씩)
  ledSequenceOnce();

  // 참고: 여기까지가 스모크 테스트 본체.
}

void loop() {
  // 스모크 테스트라 루프에서는 아무 것도 하지 않음.
}
