// ---------------------------------------------------------
// Nano Ardule MIDI Controller
// Step 00: Base Skeleton
// 작성일: 2025-08-21
// ---------------------------------------------------------

#include <Wire.h>
#include <LiquidCrystal_I2C.h>
#include "config.h"   // 핀/상수 정의 헤더 (임시)

// LCD 객체 (1602, I2C 주소 0x27 가정)
LiquidCrystal_I2C lcd(LCD_ADDR, LCD_COLS, LCD_ROWS);

// ---------------------------------------------------------
// 전역 상태 구조체
// ---------------------------------------------------------
enum Mode {
  MODE_SINGLE,
  MODE_EDIT,
  MODE_PLAY,
  MODE_SETUP
};

struct PartState {
  uint8_t program;   // Program Change
  uint8_t bank;      // Bank Select LSB
  uint8_t volume;    // CC#7
  uint8_t pan;       // CC#10
  uint8_t reverb;    // CC#91
  uint8_t chorus;    // CC#93
};

struct AppState {
  Mode mode;
  uint8_t activePart;   // 0=A, 1=B, 2=A+B, 3=DRUMS
  PartState partA;
  PartState partB;
  PartState drums;
};

AppState app;   // 전역 상태 인스턴스

// ---------------------------------------------------------
// 초기화
// ---------------------------------------------------------
void setup() {
  // LCD 시작
  lcd.init();
  lcd.backlight();

  // 전역 상태 초기화
  app.mode = MODE_SINGLE;
  app.activePart = 0; // A

  app.partA = {0, 0, 100, 64, 40, 32};
  app.partB = {48, 0, 100, 64, 40, 32};
  app.drums = {0, 0, 100, 64, 40, 32};

  // 부팅 배너
  lcd.clear();
  lcd.setCursor(0, 0);
  lcd.print("Nano Ardule v0.0");
  lcd.setCursor(0, 1);
  lcd.print("Initializing...");
  delay(1000);

  // READY 표시
  lcd.clear();
  lcd.setCursor(4, 0);
  lcd.print("READY");
}

void loop() {
  // Step 00에서는 아무 동작 없음
}
